﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL.APIMobile.Model
{
    public class GExerciseOwl
    {
        private ZSBELearning.ContextParam ContextParam;

        public GExerciseOwl()
        {

        }

        public GExerciseOwl(ZSBELearning.ContextParam ContextParam)
        {
            this.ContextParam = ContextParam;

            if (ContextParam.ExerciseOut != null)
            {
                XmlDocument _xmlDocumentLoad = ContextParam.BLP.Avatar.Get(ContextParam.ExerciseOut, Gemini.Utility.XML.Document.New("Data"), GM.N610.ELearning.BL.Dictionary.Exercise.EventType.Load);
                XmlNode _avatarNodeLoad = _xmlDocumentLoad.DocumentElement.SelectSingleNode(BL.Dictionary.XMLNodes.Avatar);

                if (_avatarNodeLoad != null)
                {
                    on_start_comment = Gemini.Utility.XML.Node.Get.CDATA(_avatarNodeLoad);
                    on_start_image = Gemini.Utility.XML.Attribute.Get.String(_avatarNodeLoad, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.ImageURL);
                }

                XmlDocument _xmlDocumentResolve = ContextParam.BLP.Avatar.Get(ContextParam.ExerciseOut, Gemini.Utility.XML.Document.New("Data"), GM.N610.ELearning.BL.Dictionary.Exercise.EventType.Resolve);
                XmlNode _avatarNodeResolve = _xmlDocumentLoad.DocumentElement.SelectSingleNode(BL.Dictionary.XMLNodes.Avatar);

                if (_avatarNodeResolve != null)
                {
                    after_solve_comment = Gemini.Utility.XML.Node.Get.CDATA(_avatarNodeResolve);
                    after_solve_image = Gemini.Utility.XML.Attribute.Get.String(_avatarNodeResolve, PI.GM.N610.ELearning.BL.Dictionary.Exercise.XMLAttributes.ImageURL);
                }
            }
        }
        /*
            on_start_comment: string, (komentarz sowy przed odpowiedzią)
            on_start_image: string, (wizerunek sowy przed odpowiedzią)
            after_solve_comment: string, (komentarz sowy po “pokaż prawidłowe”)
            after_solve_image: string (wizerunek sowy po “pokaż prawidłowe”)
         */

        public string on_start_comment { get; set; }
        public string on_start_image { get; set; }
        public string after_solve_comment { get; set; }
        public string after_solve_image { get; set; }
    }
}